/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.inventory;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.inventory.FilteredSlot;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

public class CameraAttachmentsMenu
extends class_1703 {
    protected final class_1657 player;
    protected final int cameraSlotIndex;
    protected final ItemAndStack<CameraItem> camera;
    protected final List<Attachment<?>> attachments;
    private final boolean openedFromGui;
    protected boolean clientContentsInitialized;

    public CameraAttachmentsMenu(int containerId, class_1661 playerInventory, int cameraSlotIndex, boolean openedFromGui) {
        super(Exposure.MenuTypes.CAMERA.get(), containerId);
        this.openedFromGui = openedFromGui;
        class_1799 cameraStack = cameraSlotIndex == 40 ? (class_1799)playerInventory.field_7544.get(0) : (class_1799)playerInventory.field_7547.get(cameraSlotIndex);
        Preconditions.checkState((boolean)(cameraStack.method_7909() instanceof CameraItem), (Object)("Failed to open Camera Attachments. " + String.valueOf(cameraStack) + " is not a CameraItem."));
        this.player = playerInventory.field_7546;
        this.cameraSlotIndex = cameraSlotIndex;
        this.camera = new ItemAndStack(cameraStack);
        this.attachments = this.camera.getItem().getAttachments();
        class_1277 container = this.createAttachmentsContainer(cameraSlotIndex);
        this.addAttachmentSlots((class_1263)container);
        this.addPlayerSlots(playerInventory);
    }

    @NotNull
    protected class_1277 createAttachmentsContainer(int cameraSlotIndex) {
        class_1799[] attachmentItems = (class_1799[])this.attachments.stream().map(attachment -> attachment.get(this.camera.getItemStack()).getCopy()).toArray(class_1799[]::new);
        class_1277 container = new class_1277(this, attachmentItems){

            public int method_5444() {
                return 1;
            }
        };
        container.method_5489(c -> {
            for (int slotId = 0; slotId < c.method_5439(); ++slotId) {
                Attachment<?> attachment = this.attachments.get(slotId);
                attachment.set(this.camera.getItemStack(), c.method_5438(slotId));
                if (this.player.method_37908().method_8608() || !this.player.method_7337()) continue;
                this.player.method_31548().method_5447(cameraSlotIndex, this.camera.getItemStack());
            }
        });
        return container;
    }

    public ItemAndStack<CameraItem> getCamera() {
        return this.camera;
    }

    public boolean isOpenedFromGui() {
        return this.openedFromGui;
    }

    public void method_7610(int stateId, List<class_1799> items, class_1799 carried) {
        this.clientContentsInitialized = false;
        super.method_7610(stateId, items, carried);
        this.clientContentsInitialized = true;
    }

    protected void addAttachmentSlots(class_1263 container) {
        Map<Attachment<class_1792>, Vector2i> slotPositions = Map.of(Attachment.FILM, new Vector2i(13, 42), Attachment.FLASH, new Vector2i(147, 15), Attachment.LENS, new Vector2i(147, 43), Attachment.FILTER, new Vector2i(147, 71));
        for (int index = 0; index < this.attachments.size(); ++index) {
            Attachment<?> attachmentType = this.attachments.get(index);
            Vector2i pos = slotPositions.get(attachmentType);
            this.method_7621(new FilteredSlot(container, index, pos.x(), pos.y(), 1, this::onItemInSlotChanged, attachmentType.itemPredicate()));
        }
    }

    protected void addPlayerSlots(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, column * 18 + 8, 103 + row * 18){

                    public boolean method_7674(@NotNull class_1657 player) {
                        return super.method_7674(player) && this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean method_7682() {
                        return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }

                    public boolean method_51306() {
                        return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                    }
                });
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            int finalSlot = slot;
            this.method_7621(new class_1735((class_1263)playerInventory, finalSlot, slot * 18 + 8, 161){

                public boolean method_7674(@NotNull class_1657 player) {
                    return super.method_7674(player) && this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean method_7682() {
                    return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }

                public boolean method_51306() {
                    return this.method_34266() != CameraAttachmentsMenu.this.cameraSlotIndex;
                }
            });
        }
    }

    protected void onItemInSlotChanged(FilteredSlot.SlotChangedArgs args) {
        int slotId = args.slot().getSlotId();
        class_1799 newStack = args.newStack();
        Attachment<?> attachment = this.attachments.get(slotId);
        attachment.set(this.camera.getItemStack(), newStack);
        if (!this.player.method_37908().method_8608() || this.clientContentsInitialized) {
            if (!newStack.method_7960()) {
                attachment.playInsertSoundSided(this.player);
            } else {
                attachment.playRemoveSoundSided(this.player);
            }
            this.camera.apply((item, stack) -> item.actionPerformed((class_1799)stack, (CameraHolder)this.player));
        }
        if (!this.player.method_37908().method_8608() && this.player.method_7337()) {
            this.player.method_31548().method_5447(this.cameraSlotIndex, this.camera.getItemStack());
        }
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int slotIndex) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 clickedSlot = (class_1735)this.field_7761.get(slotIndex);
        if (clickedSlot.method_7681()) {
            class_1799 slotStack = clickedSlot.method_7677();
            itemstack = slotStack.method_7972();
            if (slotIndex < this.attachments.size() ? !this.method_7616(slotStack, this.attachments.size(), this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.attachments.size(), false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                clickedSlot.method_7673(class_1799.field_8037);
            } else {
                clickedSlot.method_7668();
            }
        }
        return itemstack;
    }

    protected boolean method_7616(class_1799 movedStack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean hasRemainder = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (movedStack.method_7946()) {
            while (!movedStack.method_7960() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot = (class_1735)this.field_7761.get(i);
                class_1799 slotStack = slot.method_7677();
                if (!slotStack.method_7960() && class_1799.method_31577((class_1799)movedStack, (class_1799)slotStack)) {
                    int maxSize;
                    int j = slotStack.method_7947() + movedStack.method_7947();
                    if (j <= (maxSize = Math.min(slot.method_7675(), movedStack.method_7914()))) {
                        movedStack.method_7939(0);
                        slotStack.method_7939(j);
                        slot.method_7668();
                        hasRemainder = true;
                    } else if (slotStack.method_7947() < maxSize) {
                        movedStack.method_7934(maxSize - slotStack.method_7947());
                        slotStack.method_7939(maxSize);
                        slot.method_7668();
                        hasRemainder = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!movedStack.method_7960()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(reverseDirection ? i < startIndex : i >= endIndex)) {
                class_1735 slot1 = (class_1735)this.field_7761.get(i);
                class_1799 movedStack1 = slot1.method_7677();
                if (movedStack1.method_7960() && slot1.method_7680(movedStack)) {
                    if (movedStack.method_7947() > slot1.method_7675()) {
                        slot1.method_53512(movedStack.method_7971(slot1.method_7675()));
                    } else {
                        slot1.method_53512(movedStack.method_7971(movedStack.method_7947()));
                    }
                    slot1.method_7668();
                    hasRemainder = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return hasRemainder;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.camera.apply((item, stack) -> item.setDisassembled((class_1799)stack, false));
        player.field_7498.method_34257();
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return CameraId.ofStack(this.camera.getItemStack()).matches(player.method_31548().method_5438(this.cameraSlotIndex));
    }

    public static CameraAttachmentsMenu fromBuffer(int containerId, class_1661 playerInventory, class_9129 buffer) {
        return new CameraAttachmentsMenu(containerId, playerInventory, buffer.readInt(), buffer.readBoolean());
    }
}

